/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.efmextra.skills.GenShinInternal;

import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class GSFallAttack
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("2797461e-2bcc-7015-bf07-390a557fed81");

    public GSFallAttack(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        Player player = (Player)executer.getOriginal();
        Vec3 epos = ((Player)executer.getOriginal()).m_20182_();
        ClipContext clipContext = new ClipContext(epos, epos.m_82520_(0.0, -3.6, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, executer.getOriginal());
        Level level = ((Player)executer.getOriginal()).m_9236_();
        BlockHitResult result = level.m_45547_(clipContext);
        boolean fallAttack = result.m_6662_() == HitResult.Type.MISS || result.m_6662_() == HitResult.Type.ENTITY;
        return !player.m_20159_() && !player.m_5833_() && playerState.canBasicAttack() && fallAttack;
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        List motions = executer.getHoldingItemCapability(InteractionHand.MAIN_HAND).getAutoAttckMotion((PlayerPatch)executer);
        StaticAnimation attackMotion = ((AnimationProvider)motions.get(motions.size() - 1)).get();
        if (attackMotion != null) {
            super.executeOnServer(executer, args);
            executer.playAnimationSynchronized(attackMotion, 0.0f);
        }
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {});
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }
}

